<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="c" uri="/WEB-INF/c.tld"%>
<%@taglib prefix="fmt" uri="/WEB-INF/fmt.tld"%>

<%@page contentType="text/html;charset=UTF-8" 
		language="java"
		import="com.ibm.hwmca.ui.bonsai.status.*,
                com.ibm.hwmca.ui.bonsai.servlet.*,
                com.ibm.hwmca.ui.bonsai.servlet.util.*,
                com.ibm.hwmca.ui.bonsai.util.*,
                com.ibm.hwmca.fw.servlet.util.*,
                com.ibm.hwmca.fw.util.*,
                java.util.*" %>

<META HTTP-EQUIV="Content-Type" CONTENT="text/html;CHARSET=UTF-8">
<HTML>

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->
<wcl:Foundation
	objectScope="session"
    wclFacadeScope="session"
    wclFacadeScopeId="<%=ControllerServlet.FACADE_ID_ATTRIBUTE %>"
    pageName="tablepage">

<HEAD>

<LINK href="/wclres/WclBaseSkinCSS.css" rel="stylesheet" type="text/css"/>

<%
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get the UISession object
    UISession uis = UISession.getUISession(HMCSession.getHMCSession(session));

    // get the list of status monitor objects
    session.setAttribute("status_monitors",
                         StatusMonitorManager.getStatusMonitorManager().
                             getStatusMonitorBeans(uis));
%>

</HEAD>

<BODY>
<CENTER>
<SPAN class="wclContainer"> 

<H2 class="lyt3">Status Overview</H2>

<TABLE border="0" cellpadding="10">

<%
    List monitorList = (List)session.getAttribute("status_monitors");
    StatusMonitorBean monitor = null;
    String statusImage = null;
    String url = null;
    int monitorCount = monitorList.size();
    int rowCount = (int)Math.ceil(monitorCount / 3.0);
    int colCount = 0;
    int index = 0;
    for (int row = 0; row < rowCount; row++)
    {
        colCount = (row + 1 == rowCount) ? monitorCount-index : 3;
%>

    <TR><TD align="center">

        <TABLE border="0" cellpadding="40"><TR valign="top">

<%
        for (int col = 0; col < colCount; col++)
        {
            monitor = (StatusMonitorBean)monitorList.get(index);
            statusImage = monitor.getStatusImage();
            url = monitor.getUrl();
%>

<%          if (url != null) {%>
            <SPAN style="cursor: pointer" onClick="">
<%          }%>
            <TD align="center">

                <TABLE border="0" cellpadding="2">

                    <TR><TD align="center">
                        <%= statusImage == null ? "" : "<IMG src='" + statusImage + "' height=12 width=12>" %>
                        <SPAN class="wclTitledLayoutTitle"><%= monitor.getName(request.getLocale()) %></SPAN>
                    </TD></TR>

                    <TR><TD align="center">
                        <IMG src="/res<%= monitor.getImage() %>">
                    </TD></TR>

                    <TR><TD align="left">
                        <FONT size="1" face="ARIAL,HELVETICA,GENEVA">
<%
            String[] lines = monitor.getDetails(request.getLocale());
            for (int j = 0; j < lines.length; j++)
            {
                out.println("                            " + lines[j] + "<BR>");
            }
%>
                        </FONT>
                    </TD></TR>

                </TABLE>

            </TD>
<%          if (url != null) {%>
            </SPAN>
<%          }%>

<%
            index++;
        }
%>

        </TR></TABLE>

    </TD></TR>

<%
    }
%>

</TABLE>

</SPAN>
</CENTER>
</BODY>

</wcl:Foundation>

</HTML>

